Attribute VB_Name = "SketchPolygonMd"
Option Explicit


' example VB applet to create n-sided polygons
'
' Parametric Technology, 1999
' jgray

Private Const PI = 3.14159265358979
Private Const degToRad = PI / 180#
Private Const radToDeg = 180# / PI

Private Enum sides
    even = 0
    odd = 1
End Enum

Private Const dev = False


Public Sub CreatePolygon(noSides As Integer, dia As Double, polygonType As String)
    
    Dim dwApp As ProDESKTOP
    Set dwApp = CreateObject("ProDESKTOP.Application")
    dwApp.SetVisible True
    
    Dim api As helm
    Set api = dwApp.TakeHelm
    
    On Error GoTo noPartDoc
    Dim doc As PartDocument
    Set doc = dwApp.GetActiveDoc
    
    Dim des As aDesign
    Set des = doc.GetDesign
    On Error GoTo 0
    
    Dim wp As aWorkplane
    Set wp = doc.GetActiveWorkplane
    
    Dim sk As aSketch
    Set sk = doc.GetActiveSketch
    
    Dim mat As zMatrix
    Set mat = wp.GetTransformToPlane
    
    'assume all in mm for now...
    dia = dia / 1000#
    Dim rad As Double
    rad = dia / 2#
    'create circle of origin
    
    Dim zLn As zCurve
    Dim ctrVector As zVector
    Set ctrVector = wp.GetLocalOrigin
    
    Dim dir As zDirection, localX As zDirection, localY As zDirection
    Set localX = wp.GetLocalX
    Set localY = wp.GetLocalY
    Set dir = localX.Cross(localY).GetDirection
    
    Set zLn = dwApp.GetClass("BasicCircle").CreateBasicCircle(ctrVector, dir, rad)
    
    Dim baseCircle As aLine
    Set baseCircle = sk.CreateLine(zLn)
    
    baseCircle.SetConstruction True
    
    If dev Then api.CommitCalls "Create Circle", False
    
    Dim angle As Double, halfAngle As Double
    angle = 360 / CDbl(noSides)
    
    angle = angle * degToRad
    halfAngle = angle / 2#
    
    Dim polyType As sides
    If noSides Mod 2 = 0 Then
        polyType = even
    Else
        polyType = odd
    End If
    
    Dim fLineV1 As zVector
    Dim fLineV2 As zVector
    
    If polygonType = "F" And polyType = even Then
        Set fLineV1 = dwApp.GetClass("Vector").CreateVector(rad, -(rad * Tan(halfAngle)), 0#)
        Set fLineV2 = dwApp.GetClass("Vector").CreateVector(rad, rad * Tan(halfAngle), 0#)
    ElseIf polygonType = "C" And polyType = even Then
        Set fLineV1 = dwApp.GetClass("Vector").CreateVector(rad * Cos(halfAngle), -(rad * Sin(halfAngle)), 0#)
        Set fLineV2 = dwApp.GetClass("Vector").CreateVector(rad * Cos(halfAngle), rad * Sin(halfAngle), 0#)
    ElseIf polygonType = "F" And polyType = odd Then
        Set fLineV1 = dwApp.GetClass("Vector").CreateVector(-(rad * Tan(halfAngle)), -rad, 0#)
        Set fLineV2 = dwApp.GetClass("Vector").CreateVector(rad * Tan(halfAngle), -rad, 0#)
    ElseIf polygonType = "C" And polyType = odd Then
        Set fLineV1 = dwApp.GetClass("Vector").CreateVector(-(rad * Sin(halfAngle)), -(rad * Cos(halfAngle)), 0#)
        Set fLineV2 = dwApp.GetClass("Vector").CreateVector((rad * Sin(halfAngle)), -(rad * Cos(halfAngle)), 0#)
    Else
        'should not be here...
        MsgBox "Error !!", vbExclamation
        Exit Sub
    End If
    
    
    Dim zfLine As zCurve
    Set zfLine = dwApp.GetClass("BasicStraight").CreateBasicStraightTwoPoints(fLineV1, fLineV2)
    zfLine.Transform mat
    
    Dim fLine As aLine
    Set fLine = sk.CreateLine(zfLine)
    If dev Then api.CommitCalls "Create Line", False
    
    'now duplicate about origin...
    Dim linesVectors() As zVector
    ReDim linesVectors(noSides - 1)
    Dim zLines() As zCurve
    ReDim zLines(noSides - 1)
    Dim lines() As aLine
    ReDim lines(noSides - 1)
    
    'reset dir to be as per base wp
    
    Set dir = dwApp.GetClass("Direction").CreateDirection(0#, 0#, 1#)
    Set linesVectors(0) = fLineV2
    Dim i As Integer
    
    For i = 1 To noSides - 1
        Set linesVectors(i) = linesVectors(i - 1).Rotate(dir, angle)
        Set zLines(i) = dwApp.GetClass("BasicStraight").CreateBasicStraightTwoPoints(linesVectors(i), linesVectors(i - 1))
        zLines(i).Transform mat
        Set lines(i) = sk.CreateLine(zLines(i))
        If dev Then
            api.CommitCalls "Create Lines", False       'dev only
            doc.Update 3                                'dev only
        End If
    Next
    
    If dev Then api.CommitCalls "Create Lines", False                  'dev only
    
    Dim lineset As ObjectSet
    Set lineset = dwApp.GetClass("ObjectSet").CreateAObjectSet
    lineset.AddMember baseCircle
    lineset.AddMember fLine
    
    For i = 1 To UBound(lines)
        lineset.AddMember lines(i)
    Next
    
    wp.AutoConstrain lineset
    
    If dev Then api.CommitCalls "Create Lines", False                  'dev only
    
    
    Dim zTan As zTangent
    Dim tanCon() As aConstraint
    ReDim tanCon(noSides - 1)
    
    If polygonType = "F" And noSides <> 4 Then
        Set lines(0) = fLine
        For i = 0 To UBound(lines)
            Set zTan = dwApp.GetClass("Tangent").CreateTangent(baseCircle, lines(i))
            Set tanCon(i) = wp.CreateConstraint(zTan)
            If dev Then
                api.CommitCalls "Tangent", False
            End If
        Next
    ElseIf polygonType = "F" And noSides = 4 Then
        Set lines(0) = fLine
        For i = 0 To UBound(lines) - 1
            Set zTan = dwApp.GetClass("Tangent").CreateTangent(baseCircle, lines(i))
            Set tanCon(i) = wp.CreateConstraint(zTan)
            If dev Then api.CommitCalls "Tangent", False
        Next
    End If
    
    
    Dim eqLen As zEqualLength
    Dim eqLenCon() As aConstraint
    ReDim eqLenCon(noSides - 1)
    
    
    For i = 1 To UBound(lines)
        Set eqLen = dwApp.GetClass("EqualLength").CreateEqualLength(fLine, lines(i))
        Set eqLenCon(i) = wp.CreateConstraint(eqLen)
        If dev Then api.CommitCalls "Equal Length", False
    Next
    
    
    api.CommitCalls "Create lines", False
    
    Exit Sub
    
noPartDoc:
    MsgBox "No Part Document Open. Please activate/open a design and try again.", vbExclamation, "No Valid Document"
    Exit Sub
    

End Sub


